#### RATINGs ####

#### LIBRARIES ####
#Install
install.packages("devtools")
install.packages("car")
install.packages("FSA")
install.packages("lattice")
install.packages("ordinal")
install.packages("RVAideMemoire")
devtools::package_deps("RVAideMemoire")
install.packages("Rcpp")
install.packages("lsmeans")
if (!requireNamespace("BiocManager", quietly = TRUE))
  install.packages("BiocManager")

BiocManager::install("mixOmics")

#Upload
library(devtools)
library(car)
library(FSA)
library(lattice)
library(ordinal)
library(RVAideMemoire)
library(Rcpp)
library(lsmeans)

#### EXPERIMENT 1 ####
#### 1. Set up working directory and data to use ####
rm(list=ls()) # Remove any variables
setwd("C:/Users/Federica/Documents/UCLan/research/John Marsh/JCognitivePsychology") # Set the working directory
getwd()

datafile = read.csv("Experiment1.csv", header=TRUE,sep = ",",dec=".") # Replace the name of the file with the one that you're analysing
head(datafile) # Generally check the file you have imported

#Rename column 'condition' with 'Sound'
colnames(datafile)[5] <- "Sound"
head(datafile)

#Create a new variable 'newcondition'
datafile$newcondition[datafile$Sound == "Quiet" & datafile$Difficulty== "Easy"] <-1
datafile$newcondition[datafile$Sound == "Quiet" & datafile$Difficulty== "Hard"] <-2
datafile$newcondition[datafile$Sound == "SS" & datafile$Difficulty== "Easy"] <-3
datafile$newcondition[datafile$Sound == "SS" & datafile$Difficulty== "Hard"] <-4
datafile$newcondition[datafile$Sound == "CS" & datafile$Difficulty=="Easy"] <-5
datafile$newcondition[datafile$Sound == "CS" & datafile$Difficulty== "Hard"] <-6
head(datafile)

table(datafile$newcondition) #cond1: 480; cond2: 432; cond3: 480; cond4: 432; cond5: 480; cond6: 432.
table(datafile$Sound) #CS: 912, quiet: 912, SS: 912.
table(datafile$Difficulty) #Easy: 1440, Hard: 1296.

#### 2. Consider only PPTs with Ratings####
#Use the subset of data with Ratings 
datafile2 <-datafile
datafile2 <-datafile2[datafile2$report == "ReportStrategy",]
head(datafile2)

#Remove missing values
datafile3 = datafile2[!is.na(datafile2$rating),]
is.na(datafile3$rating)
head(datafile3)

#### 3. Set up variables ####
colnames(datafile3) #checked the column names
col.subject =1   # specify which column your participant number is in
col.condition =9 # specify which column contains your condition number ('newcondition' column)
col.stim =3 # specify which column your item number is in
measure =  "rating" # choose dependent variable, replace the name of the measure with the one that you're analysing

#Add to dataframe the DV
datafile3$depvar = datafile3[,measure]
head(datafile3) # Generally check the file

#Add to dataframe the fixed and random factors columns
datafile3$pp = datafile3[,col.subject]
datafile3$condition = datafile3[,col.condition]
datafile3$stim = datafile3[,col.stim]
head(datafile3) # Generally check the file

#Make sure all variables are correct class
datafile3$depvar = as.factor(datafile3$depvar) 
datafile3$stim = as.factor(datafile3$stim)
datafile3$condition = as.factor(datafile3$condition)
datafile3$Sound = as.factor(datafile3$Sound)
datafile3$Difficulty = as.factor(datafile3$Difficulty)
datafile3$Set = as.factor(datafile3$Set)
datafile3$rating = as.numeric(datafile3$rating)
str(datafile3)

#### 3. Order the levels of the variables ####
#Step1: Check the levels of Difficulty and Sound
head(datafile3) # Generally check the file
levels(datafile3$Difficulty) # "Easy", "Hard"
levels(datafile3$Difficulty)[match("Easy",levels(datafile3$Difficulty))] <- "1Easy"
levels(datafile3$Difficulty)[match("Hard",levels(datafile3$Difficulty))] <- "2Hard"
levels(datafile3$Difficulty) # "1Easy", "2Hard"

levels(datafile3$Sound) # "CS"    "Quiet" "SS"  
levels(datafile3$Sound)[match("Quiet",levels(datafile3$Sound))] <- "1Quiet"
levels(datafile3$Sound)[match("SS",levels(datafile3$Sound))] <- "2SS"
levels(datafile3$Sound)[match("CS",levels(datafile3$Sound))] <- "3CS"
datafile3$Sound <- factor(datafile3$Sound, levels = c("1Quiet", "2SS", "3CS")) #Set up the order of the levels of the Sound conditions
levels(datafile3$Sound) # "1Quiet" "2SS" "3CS" 
head(datafile3) # Generally check the file

levels(datafile3$depvar) #1, 2, 3, 4
datafile3$depvar <- factor(datafile3$depvar, order = TRUE, levels = c("1", "2", "3", "4"))
datafile3$depvar #1<2<3<4

#### 4. Frequency Tables ####
mytable <- table(datafile3$depvar,datafile3$condition)
mytable
mytable.prop <- prop.table(mytable) # cell percentages
mytable.prop

sink("Experiment1_Rating_FrequencyTable.txt")
mytable
mytable.prop
sink()

#Summarize data treating Likert scores as factors
Fq_bySound <- xtabs( ~ Difficulty + depvar + Sound, data = datafile3) #same as mytable
Fq_bySound

#Bar plots by Sound
histogram(~ depvar | Sound,data=datafile3,layout=c(1,3)) # 1column and 3rows for plot

#Bar plots by Difficulty
histogram(~ depvar | Difficulty,data=datafile3,layout=c(1,2)) # 1column and 2rows for plot

#Bar plots by Sound and Difficulty
A <- histogram(~ depvar | Difficulty + Sound, data=datafile3, layout=c(2,3), col ="gray") # 2columns and 3rows for plot

#Save
jpeg('Experiment1_Ratings_barplot.jpeg')
A
dev.off()

#### 5. Models ####
#clmm models use contr.treatment as default. To compare quiet - Reversed and Reversed-Forward, we then need to relevel and have "2SS" as baseline.
datafile3 <- within(datafile3, Sound <- relevel(Sound, ref = "2SS"))
levels(datafile3$Sound) #"2SS"    "1Quiet" "3CS"
levels(datafile3$Difficulty) #"1Easy" "2Hard"

# 9. Remove interaction (but with correlation back in) for pp
model9 = clmm(depvar ~ Difficulty * Sound + (1 + Difficulty + Sound|pp) + (1|stim), data = datafile3)
summary(model9)

#### Save Model ####
sink("Experiment1_Ratings_Model9.txt")
summary(model9)
sink()

#### Plot the Data ####
graph_model <- emmip(model9, Sound ~ Difficulty) #graph with Difficulty on the X axis - TO USE

#Save
jpeg('Experiment1_Ratings_graph9.jpeg')
graph_model
dev.off()

#No significant interaction in Model9, so we do not run any pairwaise comparison.

#### EXPERIMENT 3 ####
#### 1. Set up working directory and data to use ####
rm(list=ls()) # Remove any variables
setwd("C:/Users/Federica/Documents/UCLan/research/John Marsh/JCognitivePsychology") # Set the working directory
getwd()

datafile = read.csv("Experiment3.csv", header=TRUE,sep = ",",dec=".") # Replace the name of the file with the one that you're analysing
head(datafile) # Generally check the file you have imported

#Rename column 'condition' with 'Sound'
colnames(datafile)[5] <- "Sound"
head(datafile)

#Create a new variable 'newcondition'
datafile$newcondition[datafile$Sound == "quiet" & datafile$Difficulty== "Easy"] <-1
datafile$newcondition[datafile$Sound == "quiet" & datafile$Difficulty== "Hard"] <-2
datafile$newcondition[datafile$Sound == "reversed" & datafile$Difficulty== "Easy"] <-3 #meaningless
datafile$newcondition[datafile$Sound == "reversed" & datafile$Difficulty== "Hard"] <-4 #meaningless
datafile$newcondition[datafile$Sound == "forward" & datafile$Difficulty=="Easy"] <-5 #meaningful
datafile$newcondition[datafile$Sound == "forward" & datafile$Difficulty== "Hard"] <-6 #meaningful
head(datafile)

table(datafile$newcondition) #cond1: 300; cond2: 300; cond3: 300; cond4: 300; cond5: 300; cond6: 300
table(datafile$Sound) #forward: 600, quiet: 600, reversed: 600
table(datafile$Difficulty) #Easy: 900, Hard: 900

#### 2. Consider only PPTs with Ratings####
#Use the subset of data with Ratings 
datafile2 <-datafile
head(datafile2)

#Remove missing values
datafile3 = datafile2[!is.na(datafile2$rating),]
is.na(datafile3$rating)
head(datafile3)

#### 3. Set up variables ####
colnames(datafile3) #checked the column names
col.subject =1   # specify which column your participant number is in
col.condition =8 # specify which column contains your condition number ('newcondition' column)
col.stim =3 # specify which column your item number is in
measure =  "rating" # choose dependent variable, replace the name of the measure with the one that you're analysing

#Add to dataframe the DV
datafile3$depvar = datafile3[,measure]
head(datafile3) # Generally check the file

#Add to dataframe the fixed and random factors columns
datafile3$pp = datafile3[,col.subject]
datafile3$condition = datafile3[,col.condition]
datafile3$stim = datafile3[,col.stim]
head(datafile3) # Generally check the file

#Make sure all variables are correct class
datafile3$depvar = as.factor(datafile3$depvar) 
datafile3$stim = as.factor(datafile3$stim)
datafile3$condition = as.factor(datafile3$condition)
datafile3$Sound = as.factor(datafile3$Sound)
datafile3$Difficulty = as.factor(datafile3$Difficulty)
datafile3$Set = as.factor(datafile3$Set)
datafile3$rating = as.numeric(datafile3$rating)
str(datafile3)

#### 3. Order the levels of the variables ####
#Step1: Check the levels of Difficulty and Sound
head(datafile3) # Generally check the file
levels(datafile3$Difficulty) # "Easy", "Hard"
levels(datafile3$Difficulty)[match("Easy",levels(datafile3$Difficulty))] <- "1Easy"
levels(datafile3$Difficulty)[match("Hard",levels(datafile3$Difficulty))] <- "2Hard"
levels(datafile3$Difficulty) # "1Easy", "2Hard"

levels(datafile3$Sound) # "forward"  "quiet"    "reversed" 
levels(datafile3$Sound)[match("quiet",levels(datafile3$Sound))] <- "1quiet"
levels(datafile3$Sound)[match("reversed",levels(datafile3$Sound))] <- "2reversed"
levels(datafile3$Sound)[match("forward",levels(datafile3$Sound))] <- "3forward"
datafile3$Sound <- factor(datafile3$Sound, levels = c("1quiet", "2reversed", "3forward")) #Set up the order of the levels of the Sound conditions
levels(datafile3$Sound) # "1quiet"    "2reversed" "3forward" 
head(datafile3) # Generally check the file

levels(datafile3$depvar) #1, 2, 3, 4
datafile3$depvar <- factor(datafile3$depvar, order = TRUE, levels = c("1", "2", "3", "4"))
datafile3$depvar #1<2<3<4

#### 4. Frequency Tables ####
mytable <- table(datafile3$depvar,datafile3$condition)
mytable
mytable.prop <- prop.table(mytable) # cell percentages
mytable.prop

sink("Experiment3_Rating_FrequencyTable.txt")
mytable
mytable.prop
sink()

#Summarize data treating Likert scores as factors
Fq_bySound <- xtabs( ~ Difficulty + depvar + Sound, data = datafile3) #same as mytable
Fq_bySound

#Bar plots by Sound
histogram(~ depvar | Sound,data=datafile3,layout=c(1,3)) # 1column and 3rows for plot

#Bar plots by Difficulty
histogram(~ depvar | Difficulty,data=datafile3,layout=c(1,2)) # 1column and 2rows for plot

#Bar plots by Sound and Difficulty
A <- histogram(~ depvar | Difficulty + Sound, data=datafile3, layout=c(2,3), col ="gray") # 2columns and 3rows for plot

#Save
jpeg('Experiment3_Ratings_barplot.jpeg')
A
dev.off()

#### 5. Models ####
#clmm models use contr.treatment as default. To compare quiet - Reversed and Reversed-Forward, we then need to relevel and have "2reversed" as baseline.
datafile3 <- within(datafile3, Sound <- relevel(Sound, ref = "2reversed"))
levels(datafile3$Sound) # "2reversed" "1quiet"    "3forward" 
levels(datafile3$Difficulty) #"1Easy" "2Hard"

# 10. Remove interaction and correlation for pp
model10 = clmm(depvar ~ Difficulty * Sound + (0 + Difficulty + Sound|pp) + (1|stim), data = datafile3)
summary(model10)

model102 = clmm(depvar ~ Difficulty * Sound + (0 + Difficulty + Sound|pp) + (1|stim), data = datafile3,control=clmm.control(gradTol=1e-6))
summary(model102)

# 11a. Remove one slope for pp
model11a = clmm(depvar ~ Difficulty * Sound + (1 + Sound|pp) + (1|stim), data = datafile3)
summary(model11a)

#### Save Model ####

sink("Experiment3_Ratings_Model11a.txt")
summary(model11a)
sink()

#### Plot the Data ####
graph_model <- emmip(model11a, Sound ~ Difficulty) #graph with Difficulty on the X axis - TO USE

#Save
jpeg('Experiment3_Ratings_graph11a.jpeg')
graph_model
dev.off()

#### Post hoc analysis ####
#Model11a shows a significant interaction
model11a.emm2 <- emmeans(model11a, ~ Sound|Difficulty)
pairs(model11a.emm2)

#save
sink("Experiment3_Ratings_Model11aPost hoc.txt")
pairs(model11a.emm2)
sink()

#http://rcompanion.org/handbook/G_12.html

#http://www.fabianbross.de/mixedmodels.pdf

#https://cran.r-project.org/web/packages/emmeans/vignettes/interactions.html

#### ############################################################################################### ####
#### MODELS ####
#1 Full model
model1 = clmm(depvar ~ Difficulty * Sound + (1 + Difficulty * Sound|pp) + (1 + Difficulty * Sound|stim), data = datafile3, Hess = TRUE)
summary(model1)

model1b = clmm(depvar ~ Difficulty * Sound + (1 + Difficulty * Sound|pp) + (1 + Difficulty * Sound|stim), data = datafile3, Hess = TRUE, control=clmm.control(gradTol=1e-6))
summary(model1b)

#2. Remove correlations of item
model2 = clmm(depvar ~ Difficulty * Sound + (1 + Difficulty * Sound|pp) + (0 + Difficulty * Sound|stim), data = datafile3, Hess = TRUE, control=clmm.control(gradTol=1e-6))
summary(model2)

#3 Remove interactions (with correlation back in) of item
model3 = clmm(depvar ~ Difficulty * Sound + (1 + Difficulty *Sound|pp) + (1 + Difficulty + Sound|stim), data = datafile3, Hess = TRUE)
summary(model3)

model3b = clmm(depvar ~ Difficulty * Sound + (1 + Difficulty *Sound|pp) + (1 + Difficulty + Sound|stim), data = datafile3, Hess = TRUE, control=clmm.control(gradTol=1e-6))
summary(model3b)
#RVAideMemoire::Anova.clmm(model3,type="II")

# 4. Remove correlation and interactions of item
model4 = clmm(depvar ~ Difficulty * Sound + (1 + Difficulty * Sound|pp) + (0 + Difficulty + Sound|stim), data = datafile3, Hess = TRUE)
summary(model4)

model4b = clmm(depvar ~ Difficulty * Sound + (1 + Difficulty * Sound|pp) + (0 + Difficulty + Sound|stim), data = datafile3, Hess = TRUE,control=clmm.control(gradTol=1e-6))
summary(model4b)

# 5a. Remove one of the slopes
model5a = clmm(depvar ~ Difficulty * Sound  + (1 + Difficulty * Sound|pp) + (1 + Difficulty|stim), data = datafile3)
summary(model5a)

model5a2 = clmm(depvar ~ Difficulty * Sound  + (1 + Difficulty * Sound|pp) + (1 + Difficulty|stim), data = datafile3, control=clmm.control(gradTol=1e-6))
summary(model5a2)

# 5b. Remove one of the slopes
model5b = clmm(depvar ~ Difficulty * Sound + (1 + Difficulty * Sound|pp) + (1 + Sound|stim), data = datafile3)
summary(model5b)

model5b2 = clmm(depvar ~ Difficulty * Sound + (1 + Difficulty * Sound|pp) + (1 + Sound|stim), data = datafile3, control=clmm.control(gradTol=1e-6))
summary(model5b2)

# 6a. Again, without correlation
model6a = clmm(depvar ~ Difficulty * Sound  + (1 + Difficulty * Sound|pp) + (0 + Difficulty|stim), data = datafile3)
summary(model6a)

model6a2 = clmm(depvar ~ Difficulty * Sound  + (1 + Difficulty * Sound|pp) + (0 + Difficulty|stim), data = datafile3, control=clmm.control(gradTol=1e-6))
summary(model6a2)

# 6b. Again, without correlation
model6b = clmm(depvar ~ Difficulty * Sound + (1 + Difficulty * Sound|pp) + (0 + Sound|stim), data = datafile3)
summary(model6b)

model6b2 = clmm(depvar ~ Difficulty * Sound + (1 + Difficulty * Sound|pp) + (0 + Sound|stim), data = datafile3, control=clmm.control(gradTol=1e-6))
summary(model6b2)

# 7. Intercept only for items
model7 = clmm(depvar ~ Difficulty * Sound  + (1 + Difficulty * Sound|pp) + (1|stim), data = datafile3)
summary(model7)

model72 = clmm(depvar ~ Difficulty * Sound  + (1 + Difficulty * Sound|pp) + (1|stim), data = datafile3,control=clmm.control(gradTol=1e-6))
summary(model72)

# 8. Remove correlation for pp
model8 = clmm(depvar ~ Difficulty * Sound + (0 + Difficulty * Sound|pp) + (1|stim), data = datafile3)
summary(model8)

model82 = clmm(depvar ~ Difficulty * Sound + (0 + Difficulty * Sound|pp) + (1|stim), data = datafile3, control=clmm.control(gradTol=1e-6))
summary(model82)

# 9. Remove interaction (but with correlation back in) for pp
model9 = clmm(depvar ~ Difficulty * Sound + (1 + Difficulty + Sound|pp) + (1|stim), data = datafile3)
summary(model9)

model92 = clmm(depvar ~ Difficulty * Sound + (1 + Difficulty + Sound|pp) + (1|stim), data = datafile3, control=clmm.control(gradTol=1e-6))
summary(model92)

# 10. Remove interaction and correlation for pp
model10 = clmm(depvar ~ Difficulty * Sound + (0 + Difficulty + Sound|pp) + (1|stim), data = datafile3)
summary(model10)

model102 = clmm(depvar ~ Difficulty * Sound + (0 + Difficulty + Sound|pp) + (1|stim), data = datafile3,control=clmm.control(gradTol=1e-6))
summary(model102)

# 11a. Remove one slope for pp
model11a = clmm(depvar ~ Difficulty * Sound + (1 + Sound|pp) + (1|stim), data = datafile3)
summary(model11a)

model11a2 = clmm(depvar ~ Difficulty * Sound + (1 + Sound|pp) + (1|stim), data = datafile3,control=clmm.control(gradTol=1e-6))
summary(model11a2)

# 11b. Remove one slope for pp
model11b = clmm(depvar ~ Difficulty * Sound  + (1 + Difficulty|pp) + (1|stim), data = datafile3)
summary(model11b)

model11b2 = clmm(depvar ~ Difficulty * Sound  + (1 + Difficulty|pp) + (1|stim), data = datafile3,control=clmm.control(gradTol=1e-6))
summary(model11b2)

# 12a. Again without correlation for pp
model12a = clmm(depvar ~ Difficulty * Sound +  (0 + Difficulty|pp) + (1|stim), data = datafile3)
summary(model12a)

model12a2 = clmm(depvar ~ Difficulty * Sound +  (0 + Difficulty|pp) + (1|stim), data = datafile3,control=clmm.control(gradTol=1e-6))
summary(model12a2)

# 12b. Again without correlation for ppSound
model12b = clmm(depvar ~ Difficulty * Sound  +  (0 + Sound|pp) + (1|stim), data = datafile3)
summary(model12b)

model12b2 = clmm(depvar ~ Difficulty * Sound  +  (0 + Sound|pp) + (1|stim), data = datafile3,control=clmm.control(gradTol=1e-6))
summary(model12b2)

# 13. Intercepts only 
model13 = clmm(depvar ~ Difficulty * Sound + (1|pp) + (1|stim), data = datafile3)
summary(model13)

model132 = clmm(depvar ~ Difficulty * Sound + (1|pp) + (1|stim), data = datafile3, control=clmm.control(gradTol=1e-6))
summary(model132)
