
#R script for the analyses of the paper titled "The Susceptibility of Compound Remote Associate Problems to Disruption by Irrelevant Sound:
#A Window onto the Component Processes Underpinning Creative Cognition? submitted to Journal of Cognitive Psychology.

#### RATINGs ####

#### LIBRARIES ####
#Install
install.packages("devtools")
install.packages("car")
install.packages("FSA")
install.packages("lattice")
install.packages("ordinal")
install.packages("RVAideMemoire")
devtools::package_deps("RVAideMemoire")
install.packages("Rcpp")
install.packages("lsmeans")
if (!requireNamespace("BiocManager", quietly = TRUE))
  install.packages("BiocManager")

BiocManager::install("mixOmics")

#Upload
library(devtools)
library(car)
library(FSA)
library(lattice)
library(ordinal)
library(RVAideMemoire)
library(Rcpp)
library(lsmeans)

#### EXPERIMENT 1 ####
#### 1. Set up working directory and data to use ####
rm(list=ls()) # Remove any variables
setwd("C:/Users/Federica/Documents/UCLan/research/John Marsh/JCognitivePsychology/revision3") # Set the working directory
getwd()

datafile = read.csv("Experiment1.csv", header=TRUE,sep = ",",dec=".") # Replace the name of the file with the one that you're analysing
head(datafile) # Generally check the file you have imported

#Rename column 'condition' with 'Sound'
colnames(datafile)[5] <- "Sound"
head(datafile)

#Create a new variable 'newcondition'
datafile$newcondition[datafile$Sound == "Quiet" & datafile$Difficulty== "Easy"] <-1
datafile$newcondition[datafile$Sound == "Quiet" & datafile$Difficulty== "Hard"] <-2
datafile$newcondition[datafile$Sound == "SS" & datafile$Difficulty== "Easy"] <-3
datafile$newcondition[datafile$Sound == "SS" & datafile$Difficulty== "Hard"] <-4
datafile$newcondition[datafile$Sound == "CS" & datafile$Difficulty=="Easy"] <-5
datafile$newcondition[datafile$Sound == "CS" & datafile$Difficulty== "Hard"] <-6
head(datafile)

table(datafile$newcondition) #cond1: 480; cond2: 432; cond3: 480; cond4: 432; cond5: 480; cond6: 432.
table(datafile$Sound) #CS: 912, quiet: 912, SS: 912.
table(datafile$Difficulty) #Easy: 1440, Hard: 1296.

#Create a new variable 'nitem'
datafile$nitem[datafile$Set == 1 & datafile$Item == 1] <-1
datafile$nitem[datafile$Set == 1 & datafile$Item == 2] <-2
datafile$nitem[datafile$Set == 1 & datafile$Item == 3] <-3
datafile$nitem[datafile$Set == 1 & datafile$Item == 4] <-4
datafile$nitem[datafile$Set == 1 & datafile$Item == 5] <-5
datafile$nitem[datafile$Set == 1 & datafile$Item == 6] <-6
datafile$nitem[datafile$Set == 1 & datafile$Item == 7] <-7
datafile$nitem[datafile$Set == 1 & datafile$Item == 8] <-8
datafile$nitem[datafile$Set == 1 & datafile$Item == 9] <-9
datafile$nitem[datafile$Set == 1 & datafile$Item == 10] <-10
datafile$nitem[datafile$Set == 1 & datafile$Item == 11] <-11
datafile$nitem[datafile$Set == 1 & datafile$Item == 12] <-12
datafile$nitem[datafile$Set == 1 & datafile$Item == 13] <-13
datafile$nitem[datafile$Set == 1 & datafile$Item == 14] <-14
datafile$nitem[datafile$Set == 1 & datafile$Item == 15] <-15
datafile$nitem[datafile$Set == 1 & datafile$Item == 16] <-16
datafile$nitem[datafile$Set == 1 & datafile$Item == 17] <-17
datafile$nitem[datafile$Set == 1 & datafile$Item == 18] <-18
datafile$nitem[datafile$Set == 1 & datafile$Item == 19] <-19

datafile$nitem[datafile$Set == 2 & datafile$Item == 1] <-20
datafile$nitem[datafile$Set == 2 & datafile$Item == 2] <-21
datafile$nitem[datafile$Set == 2 & datafile$Item == 3] <-22
datafile$nitem[datafile$Set == 2 & datafile$Item == 4] <-23
datafile$nitem[datafile$Set == 2 & datafile$Item == 5] <-24
datafile$nitem[datafile$Set == 2 & datafile$Item == 6] <-25
datafile$nitem[datafile$Set == 2 & datafile$Item == 7] <-26
datafile$nitem[datafile$Set == 2 & datafile$Item == 8] <-27
datafile$nitem[datafile$Set == 2 & datafile$Item == 9] <-28
datafile$nitem[datafile$Set == 2 & datafile$Item == 10] <-29
datafile$nitem[datafile$Set == 2 & datafile$Item == 11] <-30
datafile$nitem[datafile$Set == 2 & datafile$Item == 12] <-31
datafile$nitem[datafile$Set == 2 & datafile$Item == 13] <-32
datafile$nitem[datafile$Set == 2 & datafile$Item == 14] <-33
datafile$nitem[datafile$Set == 2 & datafile$Item == 15] <-34
datafile$nitem[datafile$Set == 2 & datafile$Item == 16] <-35
datafile$nitem[datafile$Set == 2 & datafile$Item == 17] <-36
datafile$nitem[datafile$Set == 2 & datafile$Item == 18] <-37
datafile$nitem[datafile$Set == 2 & datafile$Item == 19] <-38

datafile$nitem[datafile$Set == 3 & datafile$Item == 1] <-39
datafile$nitem[datafile$Set == 3 & datafile$Item == 2] <-40
datafile$nitem[datafile$Set == 3 & datafile$Item == 3] <-41
datafile$nitem[datafile$Set == 3 & datafile$Item == 4] <-42
datafile$nitem[datafile$Set == 3 & datafile$Item == 5] <-43
datafile$nitem[datafile$Set == 3 & datafile$Item == 6] <-44
datafile$nitem[datafile$Set == 3 & datafile$Item == 7] <-45
datafile$nitem[datafile$Set == 3 & datafile$Item == 8] <-46
datafile$nitem[datafile$Set == 3 & datafile$Item == 9] <-47
datafile$nitem[datafile$Set == 3 & datafile$Item == 10] <-48
datafile$nitem[datafile$Set == 3 & datafile$Item == 11] <-49
datafile$nitem[datafile$Set == 3 & datafile$Item == 12] <-50
datafile$nitem[datafile$Set == 3 & datafile$Item == 13] <-51
datafile$nitem[datafile$Set == 3 & datafile$Item == 14] <-52
datafile$nitem[datafile$Set == 3 & datafile$Item == 15] <-53
datafile$nitem[datafile$Set == 3 & datafile$Item == 16] <-54
datafile$nitem[datafile$Set == 3 & datafile$Item == 17] <-55
datafile$nitem[datafile$Set == 3 & datafile$Item == 18] <-56
datafile$nitem[datafile$Set == 3 & datafile$Item == 19] <-57

unique(datafile$nitem) #57 (unique) items
head(datafile)

#### 2. Consider only PPTs with Ratings####
#Use the subset of data with Ratings 
datafile2 <-datafile
datafile2 <-datafile2[datafile2$report == "ReportStrategy",]
head(datafile2)

#Remove missing values
datafile3 = datafile2[!is.na(datafile2$rating),]
is.na(datafile3$rating)
head(datafile3)

#### 3. Set up variables ####
colnames(datafile3) #checked the column names
col.subject =1   # specify which column your participant number is in ("Participant" column)
col.condition =9 # specify which column contains your condition number ("newcondition" column)
col.stim =10 # specify which column your item number is in ("nitem" column)
measure =  "rating" # choose dependent variable, replace the name of the measure with the one that you're analysing

#Add to dataframe the DV
datafile3$depvar = datafile3[,measure]
head(datafile3) # Generally check the file

#Add to dataframe the fixed and random factors columns
datafile3$pp = datafile3[,col.subject]
datafile3$condition = datafile3[,col.condition]
datafile3$stim = datafile3[,col.stim]
head(datafile3) # Generally check the file

#Make sure all variables are correct class
datafile3$depvar = as.factor(datafile3$depvar) 
datafile3$stim = as.factor(datafile3$stim)
datafile3$condition = as.factor(datafile3$condition)
datafile3$Sound = as.factor(datafile3$Sound)
datafile3$Difficulty = as.factor(datafile3$Difficulty)
datafile3$Set = as.factor(datafile3$Set)
datafile3$rating = as.numeric(datafile3$rating)
str(datafile3)

#### 3. Order the levels of the variables ####
#Step1: Check the levels of Difficulty and Sound
head(datafile3) # Generally check the file
levels(datafile3$Difficulty) # "Easy", "Hard"
levels(datafile3$Difficulty)[match("Easy",levels(datafile3$Difficulty))] <- "1Easy"
levels(datafile3$Difficulty)[match("Hard",levels(datafile3$Difficulty))] <- "2Hard"
levels(datafile3$Difficulty) # "1Easy", "2Hard"

levels(datafile3$Sound) # "CS"    "Quiet" "SS"  
levels(datafile3$Sound)[match("Quiet",levels(datafile3$Sound))] <- "1Quiet"
levels(datafile3$Sound)[match("SS",levels(datafile3$Sound))] <- "2SS"
levels(datafile3$Sound)[match("CS",levels(datafile3$Sound))] <- "3CS"
datafile3$Sound <- factor(datafile3$Sound, levels = c("1Quiet", "2SS", "3CS")) #Set up the order of the levels of the Sound conditions
levels(datafile3$Sound) # "1Quiet" "2SS" "3CS" 
head(datafile3) # Generally check the file

levels(datafile3$depvar) #1, 2, 3, 4
datafile3$depvar <- factor(datafile3$depvar, order = TRUE, levels = c("1", "2", "3", "4"))
datafile3$depvar #1<2<3<4

#### 4. Frequency Tables ####
mytable <- table(datafile3$depvar,datafile3$condition)
mytable
mytable.prop <- prop.table(mytable) # cell percentages
mytable.prop

sink("Experiment1_Rating_FrequencyTable.txt")
mytable
mytable.prop
sink()

#Summarize data treating Likert scores as factors
Fq_bySound <- xtabs( ~ Difficulty + depvar + Sound, data = datafile3) #same as mytable
Fq_bySound

#Bar plots by Sound
histogram(~ depvar | Sound,data=datafile3,layout=c(1,3)) # 1column and 3rows for plot

#Bar plots by Difficulty
histogram(~ depvar | Difficulty,data=datafile3,layout=c(1,2)) # 1column and 2rows for plot

#Bar plots by Sound and Difficulty
A <- histogram(~ depvar | Difficulty + Sound, data=datafile3, layout=c(2,3), col ="gray") # 2columns and 3rows for plot

#Save
jpeg('Experiment1_Ratings_barplot.jpeg')
A
dev.off()

#### 5. Models ####
#clmm models use contr.treatment as default. To compare quiet - Reversed and Reversed-Forward, we then need to relevel and have "2SS" as baseline.
datafile3 <- within(datafile3, Sound <- relevel(Sound, ref = "2SS"))
levels(datafile3$Sound) #"2SS"    "1Quiet" "3CS"
levels(datafile3$Difficulty) #"1Easy" "2Hard"

#Final model
model3 = clmm(depvar ~ Difficulty * Sound + (1 + Difficulty * Sound |pp) + (1|stim), data = datafile3)
summary(model3)

#### Save Model ####
sink("Experiment1_Ratings_Model3.txt")
summary(model3)
sink()

#### Plot the Data ####
graph_model <- emmip(model3, Sound ~ Difficulty) #graph with Difficulty on the X axis - TO USE

#Save
jpeg('Experiment1_Ratings_graph3.jpeg')
graph_model
dev.off()

#No significant interaction in Model9, so we do not run any pairwaise comparison.

#### EXPERIMENT 3 ####
#### 1. Set up working directory and data to use ####
rm(list=ls()) # Remove any variables
setwd("C:/Users/Federica/Documents/UCLan/research/John Marsh/JCognitivePsychology/revision3") # Set the working directory
getwd()

datafile = read.csv("Experiment3.csv", header=TRUE,sep = ",",dec=".") # Replace the name of the file with the one that you're analysing
head(datafile) # Generally check the file you have imported

#Rename column 'condition' with 'Sound'
colnames(datafile)[5] <- "Sound"
head(datafile)

#Create a new variable 'newcondition'
datafile$newcondition[datafile$Sound == "quiet" & datafile$Difficulty== "Easy"] <-1
datafile$newcondition[datafile$Sound == "quiet" & datafile$Difficulty== "Hard"] <-2
datafile$newcondition[datafile$Sound == "reversed" & datafile$Difficulty== "Easy"] <-3 #meaningless
datafile$newcondition[datafile$Sound == "reversed" & datafile$Difficulty== "Hard"] <-4 #meaningless
datafile$newcondition[datafile$Sound == "forward" & datafile$Difficulty=="Easy"] <-5 #meaningful
datafile$newcondition[datafile$Sound == "forward" & datafile$Difficulty== "Hard"] <-6 #meaningful
head(datafile)

table(datafile$newcondition) #cond1: 300; cond2: 300; cond3: 300; cond4: 300; cond5: 300; cond6: 300
table(datafile$Sound) #forward: 600, quiet: 600, reversed: 600
table(datafile$Difficulty) #Easy: 900, Hard: 900

#Create a new variable 'nitem'
datafile$nitem[datafile$Set == 1 & datafile$Item == 1] <-1
datafile$nitem[datafile$Set == 1 & datafile$Item == 2] <-2
datafile$nitem[datafile$Set == 1 & datafile$Item == 3] <-3
datafile$nitem[datafile$Set == 1 & datafile$Item == 4] <-4
datafile$nitem[datafile$Set == 1 & datafile$Item == 5] <-5
datafile$nitem[datafile$Set == 1 & datafile$Item == 6] <-6
datafile$nitem[datafile$Set == 1 & datafile$Item == 7] <-7
datafile$nitem[datafile$Set == 1 & datafile$Item == 8] <-8
datafile$nitem[datafile$Set == 1 & datafile$Item == 9] <-9
datafile$nitem[datafile$Set == 1 & datafile$Item == 10] <-10
datafile$nitem[datafile$Set == 1 & datafile$Item == 11] <-11
datafile$nitem[datafile$Set == 1 & datafile$Item == 12] <-12
datafile$nitem[datafile$Set == 1 & datafile$Item == 13] <-13
datafile$nitem[datafile$Set == 1 & datafile$Item == 14] <-14
datafile$nitem[datafile$Set == 1 & datafile$Item == 15] <-15
datafile$nitem[datafile$Set == 1 & datafile$Item == 16] <-16
datafile$nitem[datafile$Set == 1 & datafile$Item == 17] <-17
datafile$nitem[datafile$Set == 1 & datafile$Item == 18] <-18
datafile$nitem[datafile$Set == 1 & datafile$Item == 19] <-19
datafile$nitem[datafile$Set == 1 & datafile$Item == 20] <-20

datafile$nitem[datafile$Set == 2 & datafile$Item == 1] <-21
datafile$nitem[datafile$Set == 2 & datafile$Item == 2] <-22
datafile$nitem[datafile$Set == 2 & datafile$Item == 3] <-23
datafile$nitem[datafile$Set == 2 & datafile$Item == 4] <-24
datafile$nitem[datafile$Set == 2 & datafile$Item == 5] <-25
datafile$nitem[datafile$Set == 2 & datafile$Item == 6] <-26
datafile$nitem[datafile$Set == 2 & datafile$Item == 7] <-27
datafile$nitem[datafile$Set == 2 & datafile$Item == 8] <-28
datafile$nitem[datafile$Set == 2 & datafile$Item == 9] <-29
datafile$nitem[datafile$Set == 2 & datafile$Item == 10] <-30
datafile$nitem[datafile$Set == 2 & datafile$Item == 11] <-31
datafile$nitem[datafile$Set == 2 & datafile$Item == 12] <-32
datafile$nitem[datafile$Set == 2 & datafile$Item == 13] <-33
datafile$nitem[datafile$Set == 2 & datafile$Item == 14] <-34
datafile$nitem[datafile$Set == 2 & datafile$Item == 15] <-35
datafile$nitem[datafile$Set == 2 & datafile$Item == 16] <-36
datafile$nitem[datafile$Set == 2 & datafile$Item == 17] <-37
datafile$nitem[datafile$Set == 2 & datafile$Item == 18] <-38
datafile$nitem[datafile$Set == 2 & datafile$Item == 19] <-39
datafile$nitem[datafile$Set == 2 & datafile$Item == 20] <-40

datafile$nitem[datafile$Set == 3 & datafile$Item == 1] <-41
datafile$nitem[datafile$Set == 3 & datafile$Item == 2] <-42
datafile$nitem[datafile$Set == 3 & datafile$Item == 3] <-43
datafile$nitem[datafile$Set == 3 & datafile$Item == 4] <-44
datafile$nitem[datafile$Set == 3 & datafile$Item == 5] <-45
datafile$nitem[datafile$Set == 3 & datafile$Item == 6] <-46
datafile$nitem[datafile$Set == 3 & datafile$Item == 7] <-47
datafile$nitem[datafile$Set == 3 & datafile$Item == 8] <-48
datafile$nitem[datafile$Set == 3 & datafile$Item == 9] <-49
datafile$nitem[datafile$Set == 3 & datafile$Item == 10] <-50
datafile$nitem[datafile$Set == 3 & datafile$Item == 11] <-51
datafile$nitem[datafile$Set == 3 & datafile$Item == 12] <-52
datafile$nitem[datafile$Set == 3 & datafile$Item == 13] <-53
datafile$nitem[datafile$Set == 3 & datafile$Item == 14] <-54
datafile$nitem[datafile$Set == 3 & datafile$Item == 15] <-55
datafile$nitem[datafile$Set == 3 & datafile$Item == 16] <-56
datafile$nitem[datafile$Set == 3 & datafile$Item == 17] <-57
datafile$nitem[datafile$Set == 3 & datafile$Item == 18] <-58
datafile$nitem[datafile$Set == 3 & datafile$Item == 19] <-59
datafile$nitem[datafile$Set == 3 & datafile$Item == 20] <-60

unique(datafile$nitem) #60 (unique) items
head(datafile)

#### 2. Consider only PPTs with Ratings####
#Use the subset of data with Ratings 
datafile2 <-datafile
head(datafile2)

#Remove missing values
datafile3 = datafile2[!is.na(datafile2$rating),]
is.na(datafile3$rating)
head(datafile3)

#### 3. Set up variables ####
colnames(datafile3) #checked the column names
col.subject =1   # specify which column your participant number is in ("Participant" column)
col.condition =8 # specify which column contains your condition number ("newcondition" column)
col.stim =9 # specify which column your item number is in ("nitem" column)
measure =  "rating" # choose dependent variable, replace the name of the measure with the one that you're analysing

#Add to dataframe the DV
datafile3$depvar = datafile3[,measure]
head(datafile3) # Generally check the file

#Add to dataframe the fixed and random factors columns
datafile3$pp = datafile3[,col.subject]
datafile3$condition = datafile3[,col.condition]
datafile3$stim = datafile3[,col.stim]
head(datafile3) # Generally check the file

#Make sure all variables are correct class
datafile3$depvar = as.factor(datafile3$depvar) 
datafile3$stim = as.factor(datafile3$stim)
datafile3$condition = as.factor(datafile3$condition)
datafile3$Sound = as.factor(datafile3$Sound)
datafile3$Difficulty = as.factor(datafile3$Difficulty)
datafile3$Set = as.factor(datafile3$Set)
datafile3$rating = as.numeric(datafile3$rating)
str(datafile3)

#### 3. Order the levels of the variables ####
#Step1: Check the levels of Difficulty and Sound
head(datafile3) # Generally check the file
levels(datafile3$Difficulty) # "Easy", "Hard"
levels(datafile3$Difficulty)[match("Easy",levels(datafile3$Difficulty))] <- "1Easy"
levels(datafile3$Difficulty)[match("Hard",levels(datafile3$Difficulty))] <- "2Hard"
levels(datafile3$Difficulty) # "1Easy", "2Hard"

levels(datafile3$Sound) # "forward"  "quiet"    "reversed" 
levels(datafile3$Sound)[match("quiet",levels(datafile3$Sound))] <- "1quiet"
levels(datafile3$Sound)[match("reversed",levels(datafile3$Sound))] <- "2reversed"
levels(datafile3$Sound)[match("forward",levels(datafile3$Sound))] <- "3forward"
datafile3$Sound <- factor(datafile3$Sound, levels = c("1quiet", "2reversed", "3forward")) #Set up the order of the levels of the Sound conditions
levels(datafile3$Sound) # "1quiet"    "2reversed" "3forward" 
head(datafile3) # Generally check the file

levels(datafile3$depvar) #1, 2, 3, 4
datafile3$depvar <- factor(datafile3$depvar, order = TRUE, levels = c("1", "2", "3", "4"))
datafile3$depvar #1<2<3<4

#### 4. Frequency Tables ####
mytable <- table(datafile3$depvar,datafile3$condition)
mytable
mytable.prop <- prop.table(mytable) # cell percentages
mytable.prop

sink("Experiment3_Rating_FrequencyTable.txt")
mytable
mytable.prop
sink()

#Summarize data treating Likert scores as factors
Fq_bySound <- xtabs( ~ Difficulty + depvar + Sound, data = datafile3) #same as mytable
Fq_bySound

#Bar plots by Sound
histogram(~ depvar | Sound,data=datafile3,layout=c(1,3)) # 1column and 3rows for plot

#Bar plots by Difficulty
histogram(~ depvar | Difficulty,data=datafile3,layout=c(1,2)) # 1column and 2rows for plot

#Bar plots by Sound and Difficulty
A <- histogram(~ depvar | Difficulty + Sound, data=datafile3, layout=c(2,3), col ="gray") # 2columns and 3rows for plot

#Save
jpeg('Experiment3_Ratings_barplot.jpeg')
A
dev.off()

#### 5. Models ####
#clmm models use contr.treatment as default. To compare quiet - Reversed and Reversed-Forward, we then need to relevel and have "2reversed" as baseline.
datafile3 <- within(datafile3, Sound <- relevel(Sound, ref = "2reversed"))
levels(datafile3$Sound) # "2reversed" "1quiet"    "3forward" 
levels(datafile3$Difficulty) #"1Easy" "2Hard"

#Final model
model3 = clmm(depvar ~ Difficulty * Sound + (1 + Difficulty * Sound |pp) + (1|stim), data = datafile3)
summary(model3)

#### Save Model ####
sink("Experiment3_Ratings_Model3.txt")
summary(model3)
sink()

#### Plot the Data ####
graph_model <- emmip(model3, Sound ~ Difficulty) #graph with Difficulty on the X axis - TO USE

#Save
jpeg('Experiment3_Ratings_graph3.jpeg')
graph_model
dev.off()

#### Post hoc analysis ####
#Model11a shows a significant interaction
model3.emm2 <- emmeans(model3, ~ Sound|Difficulty)
pairs(model3.emm2)

#save
sink("Experiment3_Ratings_Model3Post hoc.txt")
pairs(model3.emm2)
sink()

#http://rcompanion.org/handbook/G_12.html
#https://cran.r-project.org/web/packages/emmeans/vignettes/interactions.html
#http://www.fabianbross.de/mixedmodels.pdf