#include <oxstd.h>
//#include <oxdraw.h>
#include <packages/gnudraw/gnudraw.h>
#include <oxfloat.h>
#import  <maximize>
#import  <database>
#include <packages/ssfpack/ssfpack.h>
#include "testres.ox"

static decl s_mY, s_cT;					// data (1 x T) and T
static decl s_mOmega, s_mPhi, s_mSigma, s_mDelta, s_mJ_Phi, s_mJ_Omega, s_mJ_Delta, s_mX;
static decl s_SigmaEta_i, s_SigmaEta_c, s_dRho_Eta,
			s_SigmaZeta_i, s_SigmaZeta_c, s_dRho_Zeta,
			s_SigmaN1_i, s_SigmaN1_c, s_dRho_N1,
			s_SigmaN2_i, s_SigmaN2_c, s_dRho_N2,
			s_SigmaN3_i, s_SigmaN3_c, s_dRho_N3,
			s_SigmaN4_i, s_SigmaN4_c, s_dRho_N4,
			s_SigmaEpsilon_i, s_SigmaEpsilon_c, s_dRho_Eps, s_mN;
static decl s_dSigma, s_dVar;			// residual std.err. and scale factor
SetStsmModel(const vP)
{
	// Hyperparameters 
	s_SigmaEta_i = exp(0);    s_SigmaEta_c = exp(2.0 * vP[1]);
	s_dRho_Eta = vP[2]/sqrt(1+vP[2]^2);

	s_SigmaZeta_i = exp(2.0 * vP[3]);	s_SigmaZeta_c = exp(2.0 * vP[4]);
	s_dRho_Zeta = vP[5]/sqrt(1+vP[5]^2);

	s_SigmaN1_i = exp(2.0 * vP[6]);  	s_SigmaN1_c = exp(2.0 * vP[7]);
	s_dRho_N1 =  vP[8]/sqrt(1+vP[8]^2);

	s_SigmaN2_i = exp(2.0 * vP[6]);	    s_SigmaN2_c = exp(2.0 * vP[10]);
	s_dRho_N2 = vP[11]/sqrt(1+vP[11]^2);

	s_SigmaN3_i = exp(2.0 * vP[6]);	s_SigmaN3_c = exp(2.0 * vP[10]);
	s_dRho_N3 = vP[14]/sqrt(1+vP[14]^2);

	s_SigmaN4_i = exp(2.0 * vP[6]);	s_SigmaN4_c = exp(2.0 * vP[7]);
	s_dRho_N4 = vP[17]/sqrt(1+vP[17]^2);

	s_SigmaEpsilon_i = exp(2*vP[18]);	s_SigmaEpsilon_c = exp(2.0 * vP[19]);
	s_dRho_Eps = vP[20]/sqrt(1+vP[20]^2);
	decl mN_i = diag(s_SigmaN1_i~s_SigmaN2_i~s_SigmaN3_i~s_SigmaN4_i);
	decl mN_c = diag(s_SigmaN1_c~s_SigmaN2_c~s_SigmaN3_c~s_SigmaN4_c);
	decl mNRho = diag(s_dRho_N1~s_dRho_N2~s_dRho_N3~s_dRho_N4) * sqrt(mN_i*mN_c);
	s_mN = mN_i~mNRho|mNRho~mN_c;
	// Sistem matrices
	decl mT = unit(4)~zeros(4,4)~ones(4,1)~zeros(4,1)|
			  zeros(4,4)~unit(4)~zeros(4,1)~ones(4,1)|
	          zeros(2,8)~unit(2);
	decl mZ = zeros(2,10);	 // Z = [z_t',0_2']  first 8 elements are time varying - see s_mJPhi
	s_mPhi = mT|mZ;
	s_mOmega = zeros(12,12);
	decl mCommon = unit(2) ** ones(4,1);
	decl mSEta = s_SigmaEta_i~s_dRho_Eta*sqrt(s_SigmaEta_i*s_SigmaEta_c)|
 				 s_dRho_Eta*sqrt(s_SigmaEta_i*s_SigmaEta_c)~s_SigmaEta_c;
	decl mSZeta = s_SigmaZeta_i~(s_dRho_Zeta*sqrt(s_SigmaZeta_i*s_SigmaZeta_c))|
 				 (s_dRho_Zeta*sqrt(s_SigmaZeta_i*s_SigmaZeta_c))~s_SigmaZeta_c;
	decl mSEps = s_SigmaEpsilon_i~(s_dRho_Eps*sqrt(s_SigmaEpsilon_i*s_SigmaEpsilon_c))|
 				 (s_dRho_Eps*sqrt(s_SigmaEpsilon_i*s_SigmaEpsilon_c))~s_SigmaEpsilon_c;

	s_mOmega[0:7][0:7] = mCommon * mSEta * mCommon' + s_mN;
    s_mOmega[8:9][8:9] = mSZeta;
	s_mOmega[10:11][10:11] = mSEps;   // Irregular variance
//	s_mOmega[11][11] = s_SigmaEpsilon_c;   // Irregular variance 
	s_mSigma = -1.0*unit(10)|zeros(1,10);
	s_mJ_Phi = constant(-1,s_mPhi);
	s_mJ_Phi[rows(s_mJ_Phi)-2][0:3] = s_mJ_Phi[rows(s_mJ_Phi)-1][4:7] =range(0,3,1);
	s_mDelta = <>;
	s_mJ_Omega = s_mJ_Delta = <>; 
}
LogLikc(const vY, const pdLik, const pdVar)
{
    decl ret_val;
    ret_val = SsfLikConc(pdLik, pdVar, s_mY, s_mPhi, s_mOmega, s_mSigma, s_mDelta,
								s_mJ_Phi, s_mJ_Omega, s_mJ_Delta, s_mX);
	s_dSigma = sqrt(pdVar[0]);			// get sigma from SsfLikConc
	s_dVar = pdVar[0];
    return ret_val;     				// 1 indicates success, 0 failure
}
Likelihood(const vP, const pdLik, const pvSco, const pmHes)
{                       				// arguments dictated by MaxBFGS()
    decl dvar, ret_val;
    SetStsmModel(vP);			// map vP to airline model
	ret_val = LogLikc(s_mY, pdLik, &dvar);
    pdLik[0] /= s_cT;					// log-likelihood scaled by sample size
	return	ret_val;						// 1 indicates success, 0 failure
}
Stderr(const vP)
{
    decl covar, invcov,	result;
    result = Num2Derivative(Likelihood, vP, &covar);
    if (!result)
    {	print("Covar() failed in numerical second derivative  s\n");
        return zeros(vP);
    }
    invcov = invertgen(-covar, 3);
    return sqrt(diagonal(invcov) / s_cT)';
}

main()
{
	decl dbase;
	dbase = new Database();
	dbase->LoadIn7("Remittances");
	dbase->Info();
	dbase->Select( 0, {"ElSalvador"  , 0, 0 });
	dbase->Select( 1, {"Guatemala"   , 0, 0 });
	dbase->SetSelSample(2003,1,2009,7);
	decl inc = dbase->GetGroup(0)';
	decl con = dbase->GetGroup(1)';
	delete dbase;
	
	s_mY = inc|con;
	s_cT = columns(s_mY);				    // n. of observations complete series 
    s_mX = (ones(1,ceil(s_cT/4)) ** unit(4))[][:s_cT-1];    // Time varying observation matrix

	decl y, vP, ir, dlik;
		// Initial parameter values
			vP = <       0.00000;	       -0.71702;        0.53236;        -2.4481;        -2.8437;
       1373.4;	     0.049070;	      -0.72040;	       3.2141;       0.00000;        -1.6504;
       888.51;	        0.00000;	       0.00000;	         882.10;	      0.00000;
      0.00000;	       -0.40591;	       0.10773;		    -0.042689;	     -0.060224 >;
	 

     // Maximum likelihood estimation
   	MaxControl(500, 5, 0);
     //		print(vP);
   	ir = MaxBFGS(Likelihood, &vP, &dlik, 0, TRUE);
    println("\n", MaxConvergenceMsg(ir),
   	      " using numerical derivatives",
       	  "\nLog-likelihood = ", "%.8g", dlik * s_cT,
	 	 "; number of observations = ", s_cT, ";");
	println("Irregular variance income:", "%5.7f",s_SigmaEpsilon_i*s_dVar);
	println("Irregular variance cons:", "%5.7f",s_SigmaEpsilon_c*s_dVar);
		println("Rho Epsilon:", "%5.7f",s_dRho_Eps);
	println("Common Eta inc:", "%5.7f",s_SigmaEta_i*s_dVar);
	println("Common Eta con:", "%5.7f",s_SigmaEta_c*s_dVar);
	println("Common Eta Rho:", "%5.7f",s_dRho_Eta);
	println("Common Zeta inc:", "%5.7f",s_SigmaZeta_i*s_dVar);
	println("Common Zeta con:", "%5.7f",s_SigmaZeta_c*s_dVar);
	println("Common Zeta Rho:", "%5.7f",s_dRho_Zeta);
	println("Idio N1 inc:", "%5.7f",s_SigmaN1_i*s_dVar);
	println("Idio N1 con:", "%5.7f",s_SigmaN1_c*s_dVar);
	println("Rho N1:", "%5.7f",s_dRho_N1);
	println("Idio N2 inc:", "%5.7f",s_SigmaN2_i*s_dVar);
	println("Idio N2 con:", "%5.7f",s_SigmaN2_c*s_dVar);
	println("Rho N2:", "%5.7f",s_dRho_N2);
	println("Idio N3 inc:", "%5.7f",s_SigmaN3_i*s_dVar);
	println("Idio N3 con:", "%5.7f",s_SigmaN3_c*s_dVar);
	println("Rho N3:", "%5.7f",s_dRho_N3);
	println("Idio N4 inc:", "%5.7f",s_SigmaN4_i*s_dVar);
	println("Idio N4 con:", "%5.7f",s_SigmaN4_c*s_dVar);
	println("Rho N4:", "%5.7f",s_dRho_N4);
//	print(s_mN);
//	println("Sigma Eta:", "%5.7f", s_SigmaEta*s_dVar);
//	println("N covariance matrix:", "%5.7f", s_dVar*s_mN);
//	println("Sigma Zeta (slope) :", "%5.8f", s_SigmaZeta*s_dVar);
//	print(vP);

    decl md = SsfCondDens(ST_SMO, s_mY, s_mPhi, s_mOmega, s_mSigma, s_mDelta,
								s_mJ_Phi, s_mJ_Omega, s_mJ_Delta, s_mX)	 ;
	decl vWeights_i = invertsym(s_mN[0:3][0:3]) * ones(4,1)/ (ones(1,4)*invertsym(s_mN[0:3][0:3])*ones(4,1));
	print("Income: Weights for NP component:", vWeights_i');
	decl vWeights_c = invertsym(s_mN[4:7][4:7]) * ones(4,1)/ (ones(1,4)*invertsym(s_mN[4:7][4:7])*ones(4,1));
	print("Cons: Weights for NP component:", vWeights_c');
	decl vTrend_i = vWeights_i'md[:3][];
	decl vTrend_c = vWeights_c'md[4:7][];
	decl vSeas_i = sumc((md[:3][]-vTrend_i) .* s_mX);
	decl vSeas_c = sumc((md[4:7][]-vTrend_c) .* s_mX);
	decl correct = (ones(1,4)/4-vWeights_c)'md[4:7][0]; // correction to be applied to trend and seas
	correct = correct[0]; 

//	DrawTMatrix(0, s_mY|md[:11][], {""}, 1960, 1, 12, 0, 2);
	DrawTMatrix(0, s_mY[][]|vTrend_i|(vTrend_c+correct), {"Inc","Cons","Trend i", "Trend c"}, 1963, 1, 4, 0, 2);
	DrawTMatrix(1, md[8:9][], {"Slopes"}, 1963, 1, 4, 0, 2);
	DrawTMatrix(2, vSeas_i|(vSeas_c-correct), {"Seasonals"}, 1963, 1, 4, 0, 2);
	DrawTMatrix(3, s_mY-(vSeas_i|(vSeas_c-correct)), {"Seasonally adjusted series"}, 1963, 1, 12, 0, 2);
	decl mKF = KalmanFil(s_mY, s_mPhi, s_mOmega, s_mSigma, s_mDelta,
								s_mJ_Phi, s_mJ_Omega, s_mJ_Delta, s_mX);
   	decl vSInn_i = mKF[0][] .* sqrt(mKF[12][]); // standardised innovations
   	decl vSInn_c = mKF[1][] .* sqrt(mKF[rows(mKF)-1][]); // standardised innovations
	DrawTMatrix(4,vSInn_i[][5:columns(mKF)-1], {"Stand. Innovations"} ,1964, 2, 4, 0, 2);
   	DrawCorrelogram(5, vSInn_i[][5:columns(mKF)-1], "Correlogram", 12);

   	ShowDrawWindow();
	PortmanteauTest( vSInn_i[][5:columns(mKF)-1]', 4, 3, 1);
	PortmanteauTest( vSInn_i[][5:columns(mKF)-1]', 8, 3, 1);
	NormalityTest( vSInn_i[][5:columns(mKF)-1]', 1);
	PortmanteauTest( vSInn_c[][5:columns(mKF)-1]', 4, 3, 1);
	PortmanteauTest( vSInn_c[][5:columns(mKF)-1]', 8, 3, 1);
	NormalityTest( vSInn_c[][5:columns(mKF)-1]', 1);
	PortmanteauTest( vSInn_i[][5:columns(mKF)-1]'~vSInn_c[][5:columns(mKF)-1]', 4, 13, 1);
	PortmanteauTest( vSInn_i[][5:columns(mKF)-1]'~vSInn_c[][5:columns(mKF)-1]', 8, 13, 1);
	NormalityTest( vSInn_i[][5:columns(mKF)-1]'~vSInn_c[][5:columns(mKF)-1]', 1);
	print("--------------------------------------------------", "\n");
	decl vSE = Stderr(vP);
//	print("parameters with standard errors:",
//		"%cf", {"%12.5g", "  (%7.5f)"}, vP ~ vSE);
	// Standard errors for variance parameters	
	decl vSelv = < 1,3,4,6,7,10,18,19>;
    decl vDer = 2*exp(2 * vP[vSelv]);
	decl vSEvar = ( s_dVar) * vSE[vSelv] .* vDer;
	print("\n Variance parameters with standard errors:",
		"%cf", {"%12.5g", "  (%7.5f)"}, 10^7 * s_dVar * exp(2 * vP[vSelv]) ~ 10^7 *vSEvar);
	// Correlations
	decl vSelPar = <2, 5, 8,  11, 14, 17, 20>;
	decl vr =vP[vSelPar]; 
	decl dDer_r = (1 ./ sqrt(1+vr.^2)) .* (1- vr ./ ((1+vr.^2)));
	decl vSEPar = dDer_r .* vSE[vSelPar];  
	print("\n Correlation parameters with standard errors:",
		"%cf", {"%12.5g", "  (%7.5f)"}, vP[vSelPar]./ sqrt(1+vP[vSelPar].^2) ~ vSEPar);
	print("--------------------------------------------------", "\n");
	decl LR = -2*(207.41+272.77-489.81);
	print("LR:   ", LR);
	print(", p-value:    ", 1-probchi(LR,7));
}
	
