#include <oxstd.h>
//#include <oxdraw.h>
#include <packages/gnudraw/gnudraw.h>
#include <oxfloat.h>
#import  <maximize>
#import  <database>
#include <packages/ssfpack/ssfpack.h>
#include "testres.ox"

static decl s_mY, s_cT;					// data (1 x T) and T
static decl s_mOmega, s_mPhi, s_mSigma, s_mDelta, s_mJ_Phi, s_mJ_Omega, s_mJ_Delta, s_mX;
static decl s_SigmaEta_i, s_SigmaEta_c, s_dRho_Eta,
			s_SigmaZeta_i, s_SigmaZeta_c, s_dRho_Zeta,
			s_SigmaN1_i, s_SigmaN1_c, s_dRho_N1,
			s_SigmaN2_i, s_SigmaN2_c, s_dRho_N2,
			s_SigmaN3_i, s_SigmaN3_c, s_dRho_N3,
			s_SigmaN4_i, s_SigmaN4_c, s_dRho_N4,
			s_SigmaN5_i, s_SigmaN5_c, s_dRho_N5,
			s_SigmaN6_i, s_SigmaN6_c, s_dRho_N6,
			s_SigmaN7_i, s_SigmaN7_c, s_dRho_N7,
			s_SigmaN8_i, s_SigmaN8_c, s_dRho_N8,
			s_SigmaN9_i, s_SigmaN9_c, s_dRho_N9,
			s_SigmaN10_i, s_SigmaN10_c, s_dRho_N10,
			s_SigmaN11_i, s_SigmaN11_c, s_dRho_N11,
			s_SigmaN12_i, s_SigmaN12_c, s_dRho_N12,	 						
			s_SigmaEpsilon_i, s_SigmaEpsilon_c, s_dRho_Eps, s_mN;
static decl s_dSigma, s_dVar;			// residual std.err. and scale factor
SetStsmModel(const vP)
{
	// Hyperparameters 
	s_SigmaEta_i = exp(0.0);    s_SigmaEta_c = exp(2.0 * vP[1]);
	s_dRho_Eta = vP[2]/sqrt(1+vP[2]^2);

	s_SigmaZeta_i = exp(2.0 * vP[3]);	s_SigmaZeta_c = exp(2.0 * vP[4]);
	s_dRho_Zeta = vP[5]/sqrt(1+vP[5]^2);

	s_SigmaN1_i = exp(2.0 * vP[6]);  	s_SigmaN1_c = exp(2.0 * vP[7]);
	s_dRho_N1 =  vP[8]/sqrt(1+vP[8]^2);

	s_SigmaN2_i = exp(2.0 * vP[6]);	    s_SigmaN2_c =exp(2.0 * vP[7]);
	s_dRho_N2 =vP[11]/sqrt(1+vP[11]^2);

	s_SigmaN3_i = exp(2.0 * vP[6]);	s_SigmaN3_c = exp(2.0 * vP[7]); // exp(2.0 * vP[13]);
	s_dRho_N3 = vP[14]/sqrt(1+vP[14]^2);

	s_SigmaN4_i = exp(2.0 * vP[6]); 	s_SigmaN4_c = exp(2.0 * vP[7]);
	s_dRho_N4 = vP[17]/sqrt(1+vP[17]^2);

	s_SigmaN5_i = exp(2.0 * vP[6]); 	s_SigmaN5_c = exp(2.0 * vP[7]);
	s_dRho_N5 = vP[17]/sqrt(1+vP[17]^2);

	s_SigmaN6_i = exp(2.0 * vP[6]); 	s_SigmaN6_c = exp(2.0 * vP[7]);
	s_dRho_N6 = vP[17]/sqrt(1+vP[17]^2);
	
	s_SigmaN7_i = exp(2.0 * vP[6]); 	s_SigmaN7_c = exp(2.0 * vP[7]);
	s_dRho_N7 = vP[17]/sqrt(1+vP[17]^2);
	
	s_SigmaN8_i = exp(2.0 * vP[6]); 	s_SigmaN8_c = exp(2.0 * vP[7]);
	s_dRho_N8 = vP[17]/sqrt(1+vP[17]^2);

	s_SigmaN9_i = exp(2.0 * vP[6]); 	s_SigmaN9_c = exp(2.0 * vP[7]);
	s_dRho_N9 = vP[17]/sqrt(1+vP[17]^2);

	s_SigmaN10_i = exp(2.0 * vP[6]); 	s_SigmaN10_c = exp(2.0 * vP[7]);
	s_dRho_N10 = vP[17]/sqrt(1+vP[17]^2);

	s_SigmaN11_i = exp(2.0 * vP[6]); 	s_SigmaN11_c = exp(2.0 * vP[7]);
	s_dRho_N11 = vP[17]/sqrt(1+vP[17]^2);

	s_SigmaN12_i = exp(2.0 * vP[6]); 	s_SigmaN12_c = exp(2.0 * vP[7]);
	s_dRho_N12 = vP[17]/sqrt(1+vP[17]^2);

	s_SigmaEpsilon_i = exp(2.0 * vP[18]);	s_SigmaEpsilon_c = exp(2.0 * vP[19]);
	s_dRho_Eps = vP[20]/sqrt(1+vP[20]^2);
	
	decl mN_i = diag(s_SigmaN1_i~s_SigmaN2_i~s_SigmaN3_i~s_SigmaN4_i
					~s_SigmaN5_i~s_SigmaN6_i~s_SigmaN7_i~s_SigmaN8_i
					~s_SigmaN9_i~s_SigmaN10_i~s_SigmaN11_i~s_SigmaN12_i);
  	
	decl mN_c =	diag(s_SigmaN1_c~s_SigmaN2_c~s_SigmaN3_c~s_SigmaN4_c
					~s_SigmaN5_c~s_SigmaN6_c~s_SigmaN7_c~s_SigmaN8_c
					~s_SigmaN9_c~s_SigmaN10_c~s_SigmaN11_c~s_SigmaN12_c);
	
	
	decl mNRho = diag(s_dRho_N1~s_dRho_N2~s_dRho_N3~s_dRho_N4
					~s_dRho_N5~s_dRho_N6~s_dRho_N7~s_dRho_N8
					~s_dRho_N9~s_dRho_N10~s_dRho_N11~s_dRho_N12)
	* sqrt(mN_i*mN_c);
	
	s_mN = mN_i~mNRho|mNRho~mN_c;
	// System matrices
	decl mT = unit(12)~zeros(12,12)~ones(12,1)~zeros(12,1)|
			  zeros(12,12)~unit(12)~zeros(12,1)~ones(12,1)|
	          zeros(2,24)~unit(2);
	decl mZ = zeros(2,26);	 // Z = [z_t',0_2']  first 8 elements are time varying - see s_mJPhi
	s_mPhi = mT|mZ;
	s_mOmega = zeros(28,28);
	decl mCommon = unit(2) ** ones(12,1);
	decl mSEta = s_SigmaEta_i~s_dRho_Eta*sqrt(s_SigmaEta_i*s_SigmaEta_c)|
 				 s_dRho_Eta*sqrt(s_SigmaEta_i*s_SigmaEta_c)~s_SigmaEta_c;
	decl mSZeta = s_SigmaZeta_i~(s_dRho_Zeta*sqrt(s_SigmaZeta_i*s_SigmaZeta_c))|
 				 (s_dRho_Zeta*sqrt(s_SigmaZeta_i*s_SigmaZeta_c))~s_SigmaZeta_c;
	decl mSEps = s_SigmaEpsilon_i~(s_dRho_Eps*sqrt(s_SigmaEpsilon_i*s_SigmaEpsilon_c))|
 				 (s_dRho_Eps*sqrt(s_SigmaEpsilon_i*s_SigmaEpsilon_c))~s_SigmaEpsilon_c;

	s_mOmega[0:23][0:23] = mCommon * mSEta * mCommon' + s_mN;
    s_mOmega[24:25][24:25] = mSZeta;
	s_mOmega[26:27][26:27] = mSEps;   // Irregular variance
//	s_mOmega[11][11] = s_SigmaEpsilon_c;   // Irregular variance 
	s_mSigma = -1.0*unit(26)|zeros(1,26);
	s_mJ_Phi = constant(-1,s_mPhi);
	s_mJ_Phi[rows(s_mJ_Phi)-2][0:11] = s_mJ_Phi[rows(s_mJ_Phi)-1][12:23] =range(0,11,1);
	s_mDelta = <>;
	s_mJ_Omega = s_mJ_Delta = <>; 
}
LogLikc(const vY, const pdLik, const pdVar)
{
    decl ret_val;
    ret_val = SsfLikConc(pdLik, pdVar, s_mY, s_mPhi, s_mOmega, s_mSigma, s_mDelta,
								s_mJ_Phi, s_mJ_Omega, s_mJ_Delta, s_mX);
	s_dSigma = sqrt(pdVar[0]);			// get sigma from SsfLikConc
	s_dVar = pdVar[0];
    return ret_val;     				// 1 indicates success, 0 failure
}
Likelihood(const vP, const pdLik, const pvSco, const pmHes)
{                       				// arguments dictated by MaxBFGS()
    decl dvar, ret_val;
    SetStsmModel(vP);		 
	ret_val = LogLikc(s_mY, pdLik, &dvar);
    pdLik[0] /= s_cT;					// log-likelihood scaled by sample size
	return	ret_val;						// 1 indicates success, 0 failure
}
Stderr(const vP)
{
    decl covar, invcov,	result;
    result = Num2Derivative(Likelihood, vP, &covar);
    if (!result)
    {	print("Covar() failed in numerical second derivative  s\n");
        return zeros(vP);
    }
    invcov = invertgen(-covar, 3);
    return sqrt(diagonal(invcov) / s_cT)';
}

main()
{
	decl dbase;
	dbase = new Database();
	dbase->LoadIn7("Remittances");
	dbase->Info();
//	dbase->Select( 0, {"quantity"  , 0, 0 });
	dbase->Select( 0, {"ElSalvador"  , 0, 0 });
	dbase->Select( 1, {"Guatemala"   , 0, 0 });
	dbase->SetSelSample(2003,1,2009,7);
	decl inc = dbase->GetGroup(0)';
	decl con = dbase->GetGroup(1)';
	delete dbase;
	
	s_mY = inc|con;
	s_cT = columns(s_mY);				    // n. of observations complete series 
    s_mX = (ones(1,ceil(s_cT/12)) ** unit(12))[][:s_cT-1];    // Time varying observation matrix

	decl y, vP, ir, dlik;
		// Initial parameter values


	vP = <      0.00000;       -0.64034;      0.44486;      -2.2809;      -2.7381;       1373.4;      0.26526;     -0.94777;
       1.4379;       0.00000;      0.00000;       888.51;      0.00000;      0.00000;       882.10;      0.00000;      0.00000;
     -0.30622;	     -0.088069;     0.056000;     -0.282640>;

	 		
//	 these are my starting values. The ones above are the default ones
	vP = <      0.70000;       -0.64034;      0.44486;      -2.2809;      -2.7381;       563.4455;      -2.6526;     -0.94777;
  			     1.4379;       0.561400;      3.60000;       75.51;      2.004870;      0.457000;       542.10;      0.25000;      1.45780;
   			  -0.30622;	     -0.088069;     0.056000;     -0.282640>;


			  
     // Maximum likelihood estimation
   	MaxControl(-1, 5, 1);
    //		print(vP); 
   	ir = MaxBFGS(Likelihood, &vP, &dlik, 0, TRUE);
    println("\n", MaxConvergenceMsg(ir),
   	      " using numerical derivatives",
       	  "\nLog-likelihood = ", "%.8g", dlik * s_cT,
	 	 "; number of observations = ", s_cT, ";");
	println("Irregular variance El Salvador:", "%5.7f",s_SigmaEpsilon_i*s_dVar);
	println("Irregular variance Guatemala:", "%5.7f",s_SigmaEpsilon_c*s_dVar);
	println("Rho Epsilon:", "%5.7f",s_dRho_Eps);
	println("Common Eta El Salvador:", "%5.7f",s_SigmaEta_i*s_dVar);
	println("Common Eta Guatemala:", "%5.7f",s_SigmaEta_c*s_dVar);
	println("Common Eta Rho:", "%5.7f",s_dRho_Eta);
	println("Common Zeta El Salvador:", "%5.7f",s_SigmaZeta_i*s_dVar);
	println("Common Zeta Guatemala:", "%5.7f",s_SigmaZeta_c*s_dVar);
	println("Common Zeta Rho:", "%5.7f",s_dRho_Zeta);
	println("Idio N1 El Salvador:", "%5.7f",s_SigmaN1_i*s_dVar);
	println("Idio N1 Guatemala:", "%5.7f",s_SigmaN1_c*s_dVar);
	println("Rho N1:", "%5.7f",s_dRho_N1);
	println("Idio N2 El Salvador:", "%5.7f",s_SigmaN2_i*s_dVar);
	println("Idio N2 Guatemala:", "%5.7f",s_SigmaN2_c*s_dVar);
	println("Rho N2:", "%5.7f",s_dRho_N2);
	println("Idio N3 El Salvador:", "%5.7f",s_SigmaN3_i*s_dVar);
	println("Idio N3 Guatemala:", "%5.7f",s_SigmaN3_c*s_dVar);
	println("Rho N3:", "%5.7f",s_dRho_N3);
	println("Idio N4 El Salvador:", "%5.7f",s_SigmaN4_i*s_dVar);
	println("Idio N4 Guatemala:", "%5.7f",s_SigmaN4_c*s_dVar);
	println("Rho N4:", "%5.7f",s_dRho_N4);
	print(s_mN);//
	print(vP);

    decl md = SsfCondDens(ST_SMO, s_mY, s_mPhi, s_mOmega, s_mSigma, s_mDelta,
								s_mJ_Phi, s_mJ_Omega, s_mJ_Delta, s_mX)	 ;
	decl vWeights_i = invertsym(s_mN[0:11][0:11]) * ones(12,1)/ (ones(1,12)*invertsym(s_mN[0:11][0:11])*ones(12,1));
	print("El Salvador: Weights for NP component:", vWeights_i');
	decl vWeights_c = invertsym(s_mN[12:23][12:23]) * ones(12,1)/ (ones(1,12)*invertsym(s_mN[12:23][12:23])*ones(12,1));
	print("Guatemala: Weights for NP component:", vWeights_c');

	decl vTrend_i = vWeights_i'md[:11][];
	decl vTrend_c = vWeights_c'md[12:23][];
	decl vSeas_i = sumc((md[:11][]-vTrend_i) .* s_mX);
	decl vSeas_c = sumc((md[12:23][]-vTrend_c) .* s_mX);
//	decl correct = (ones(1,4)/4-vWeights)'md[:3][0]; // correction to be applied to trend and seas
//	correct = correct[0]; 

//	DrawTMatrix(0, s_mY|md[:11][], {""}, 1960, 1, 12, 0, 2);
	DrawTMatrix(0, s_mY[][]|vTrend_i|vTrend_c, {"El Salvador","Guatemala","Trend S", "Trend c"}, 2003, 1, 1, 0, 2);
	DrawTMatrix(1, md[24:25][], {"Slopes"}, 1963, 1, 4, 0, 2);
	DrawTMatrix(2, vSeas_i|vSeas_c, {"Seasonals"}, 1963, 1, 4, 0, 2);
	DrawTMatrix(3, s_mY-(vSeas_i|vSeas_c), {"Seasonally adjusted series"}, 2003, 1, 12, 0, 2);
	decl mKF = KalmanFil(s_mY, s_mPhi, s_mOmega, s_mSigma, s_mDelta,
								s_mJ_Phi, s_mJ_Omega, s_mJ_Delta, s_mX);
   	decl vSInn_i = mKF[0][] .* sqrt(mKF[28][]); // standardised innovations
   	decl vSInn_c = mKF[1][] .* sqrt(mKF[rows(mKF)-1][]); // standardised innovations
	print(mKF[28][]);
	DrawTMatrix(4,vSInn_i[][6:columns(mKF)-1], {"Stand. Innovations"} ,2003, 2, 4, 0, 2);
   	DrawCorrelogram(5, vSInn_c[][6:columns(mKF)-1], "Correlogram", 12);

   	ShowDrawWindow();
    SaveDrawWindow("remittances.eps");

	PortmanteauTest( vSInn_i[][5:columns(mKF)-1]', 12, 3, 1);
	PortmanteauTest( vSInn_i[][5:columns(mKF)-1]', 24, 3, 1);
	NormalityTest( vSInn_i[][5:columns(mKF)-1]', 1);
	PortmanteauTest( vSInn_c[][5:columns(mKF)-1]', 12, 3, 1);
	PortmanteauTest( vSInn_c[][5:columns(mKF)-1]', 24, 3, 1);
	NormalityTest( vSInn_c[][5:columns(mKF)-1]', 1);
	PortmanteauTest( vSInn_i[][5:columns(mKF)-1]'~vSInn_c[][5:columns(mKF)-1]', 12, 13, 1);
	PortmanteauTest( vSInn_i[][5:columns(mKF)-1]'~vSInn_c[][5:columns(mKF)-1]', 24, 13, 1);
	NormalityTest( vSInn_i[][5:columns(mKF)-1]'~vSInn_c[][5:columns(mKF)-1]', 1);
	print("--------------------------------------------------", "\n");
	decl vSE = Stderr(vP);
//	print("parameters with standard errors:",
//		"%cf", {"%12.5g", "  (%7.5f)"}, vP ~ vSE);
	// Standard errors for variance parameters	
	decl vSelv = < 1,3,4,6,7,18,19>;
    decl vDer = 2*exp(2 * vP[vSelv]);
	decl vSEvar = ( s_dVar) * vSE[vSelv] .* vDer;
	print("\n Variance parameters with standard errors:",
		"%cf", {"%12.5g", "  (%7.5f)"}, 10^7 * s_dVar * exp(2 * vP[vSelv]) ~ 10^7 *vSEvar);
	// Correlations
	decl vSelPar = <2, 5, 8, 11, 14, 17, 20>;
	decl vr =vP[vSelPar]; 
	decl dDer_r = (1 ./ sqrt(1+vr.^2)) .* (1- vr ./ ((1+vr.^2)));
	decl vSEPar = dDer_r .* vSE[vSelPar];  
	print("\n Correlation parameters with standard errors:",
		"%cf", {"%12.5g", "  (%7.5f)"}, vP[vSelPar]./ sqrt(1+vP[vSelPar].^2) ~ vSEPar);
	print("--------------------------------------------------", "\n");
		decl LR = -2*(207.41+269.98-487.34);
	print("LR:   ", LR); 	print(", p-value:    ", 1-probchi(LR,7));
}